# Customer Cloud Code Examples

## Overview

This folder contains code examples for Customer Cloud communication.

There are two parts:

* Sever side - cloud server scripts (PHP)
* Embedded - code that runs on the edge device (C/C++)

## Documentation

Visit https://docs.riotsecure.io for the full documentation of the communication code examples.

## Directory Structure

Directory structure:

    communication/
      RIoTCounter/
        cloud/
          server.php                   // server end point
          server-get-counter-data.php  // server data access
          dashboard-counter.html       // web UI
          riotsecure-logo.png          // graphics
        embedded/
          CounterUnoR4/                // sketch for Arduino Uno R4 WiFi
            CounterUnoR4.ino           // main file
            application.h              // application code
            riotuart.h                 // library code
          CounterUnoMega/              // sketch for Arduino Uno and Arduino Mega
            CounterUnoMega.ino         // main file
            application.h              // application code
            riotuart.h                 // library code
<!--
      RIoTMatrix/            <-- example for Arduino Uno R4 Wifi
        cloud/               <-- server side code
          server.php         <-- script that handles device messages
          matrix.php         <-- script for setting matrix
        embedded/
          MatrixUnoR4/       <-- sketch for Arduino Uno R4 WiFi
            MatrixUnoR4.ino  <-- main file
            application.h    <-- application code
            riotuart.h       <-- library code
-->