<?php
/*
File: server.php
Receiving script on the integration server - accepts a PUT request with JSON data.
This code is part of the communication code example RIoTCounter.

TODO: You must edit the code below to use your bearer token.
*/

// TODO: Edit code to use your bearer token
define("BEARER_TOKEN", "YOUR-BEARER-TOKEN");

// Call main function
main();

function main()
{
  // Get PUT data
  $json = file_get_contents('php://input');

  // Validate incoming request using Bearer authentication
  $success = verify_bearer(BEARER_TOKEN);
  if (!$success)
  {
    http_response_code(401);
    exit();
  }

  // Log the data
  $device_data = json_decode($json);
  $device_data = process_data($device_data);
  $result = log_data($device_data);

  // Send response to device
  $reponse_data = new stdClass();
  if (false !== $result)
  {
    $reponse_data->Message = "OK"; // OK
  }
  else
  {
    $reponse_data->Message = "ER"; // ERROR
  }

  echo json_encode($reponse_data);
}

// Function that verifies the bearer token
function verify_bearer($token)
{
  $success = false;

  $headers = apache_request_headers();

  if (array_key_exists("Authorization", $headers))
  {
    $auth = $headers["Authorization"];
    $auth_parts = explode(" ", $auth, 2);
    $success = ($auth_parts[0] === "Bearer") && ($auth_parts[1] === $token);
  }

  return $success;
}

// Process device data by adding and removing entries
function process_data($device_data)
{
  // Remove entries of less interest for this application
  unset($device_data->memory);
  unset($device_data->hardware);

  // Add server date and time
  $device_data->date = date('y-m-d H:i:s');

  // Add device id
  $device_data->device_id = device_id_from_guid($device_data->guid);

  return $device_data;
}

// JSON data is written to a log file. The format of the log file
// is a JSON array. The first element in the array is the most recent.
function log_data($device_data)
{
  // Set destination file
  $file_name = __DIR__ . "/data_counters.json";

  // Existing data array
  $log_data = [];

  // Check if file exists
  if (file_exists($file_name))
  {
    // Read file
    $json = file_get_contents($file_name);
    $log_data = json_decode($json);
  }

  // Add device data as the first element
  array_unshift($log_data, $device_data);

  // Maintain max array length
  if (count($log_data) > 20)
  {
    array_pop($log_data);
  }

  // Write file
  $json = json_encode($log_data, JSON_PRETTY_PRINT);
  $result = file_put_contents($file_name, $json, LOCK_EX);
  if (false === $result)
  {
    return false;
  }
  else
  {
    return true;
  }
}

// Extract tenant id from the GUID
function tenant_id_from_guid($guid)
{
  $bytes = str_split($guid, 2);
  $byte_0 = hexdec($bytes[0]);
  $byte_1 = hexdec($bytes[1]);
  $R = 82; //ord("R");
  $I = 73; //ord("I");
  $tenant_id = (($byte_0 ^ $R) << 8) | ($byte_1 ^ $I);

  return $tenant_id;
}

// Extract device id from the GUID
function device_id_from_guid($guid)
{
  $bytes = str_split($guid, 2);
  $byte_2 = hexdec($bytes[2]);
  $byte_3 = hexdec($bytes[3]);
  $o = 111; //ord("o");
  $T = 84;  //ord("T");
  $device_id = (($byte_2 ^ $o) << 8) | ($byte_3 ^ $T);

  return $device_id;
}
