/*
File: CounterUnoR4.ino
Target device: Arduino Uno R4 WiFi

Demo sketch for device to cloud communication.
The application sends a counter on a regular interval.
*/

// Include system libraries
#include <Arduino.h>
#include <SoftwareSerial.h>
#include <stdint.h>
#include <stdlib.h>

// Define this for Arduino UNO R4
#define RIOT_UART_NATIVE

// Define this for Arduino UNO/MEGA
//#define RIOT_UART_SOFTWARE

// Define serial debug output
#define ENABLE_DEBUG
// Define DEBUG_RIOT_BOARD for UNO R4
#define DEBUG_RIOT_BOARD

#ifdef ENABLE_DEBUG
  #ifdef DEBUG_RIOT_BOARD
    #define dbgRxPin 2 // green wire on TTL cable
    #define dbgTxPin 3 // white wire on TTL cable
                       // connect black wire to GND
    SoftwareSerial dbgUART(dbgRxPin, dbgTxPin);
  #else
    #define dbgUART Serial
  #endif
#endif

// Include core communication library
#include "riotuart.h"

// Include application code
#include "application.h"

void setup()
{
  #ifdef ENABLE_DEBUG
    #ifdef DEBUG_RIOT_BOARD
      pinMode(dbgRxPin, INPUT);
      pinMode(dbgTxPin, OUTPUT);
      dbgUART.begin(115200);
    #else
      dbgUART.begin(9600);
    #endif
  #endif

  // Set callback function and initialize communication
  // between the Core Firmware and the application
  riotUART.begin(application_riotuart_callback);

  // Small delay on startup
  delay(500);

  #ifdef ENABLE_DEBUG
    dbgUART.println(F("HI WORLD"));
  #endif

  // Wait for a message from the Core Firmware before processing data
  //g_application_status = APP_STATE_IDLE;
}

void loop()
{
  // Handle any communication between the Core Firmware and the application
  riotUART.loop();

  // Process application state machine
  if (g_application_status != APP_STATE_IDLE)
  {
    switch (g_application_status)
    {
      case APP_STATE_INIT:
        #ifdef ENABLE_DEBUG
          dbgUART.println(F("APP_STATE_INIT"));
        #endif
        application_init();
        g_application_status = APP_STATE_LOOP;
        break;

      case APP_STATE_LOOP:
        application_loop();
        break;

      case APP_STATE_QUIT:
        application_quit();
        #ifdef ENABLE_DEBUG
          dbgUART.println(F("APP_STATE_QUIT"));
        #endif
        g_application_status = APP_STATE_IDLE;
        break;
    }
  }
}
