# REST API Code Examples and Tools

## Documentation

Each PHP file contains a header comment that describes how to use the file.

Visit https://docs.riotsecure.io for the full documentation of the REST API code examples and tools.

## Directory Structure

Directory structure:

    restapi/
      config/
        login_template.json  <-- template login config file
      guide/
        ...                  <-- developer guide code examples
      tools/
        lib/
          ...                <-- library files (used also by examples)
        passhash/
          passhash.php       <-- generate password hash tool
        instdl/
          instdl.php         <-- RIoTInstaller download tool
        updatefw/
          updatefw.php       <-- application firmware development tool

        mylogin.json         <-- create this file based on login_template.json

## Login File

Use the template __login_template.json__ file in the __config__ directory to create a login file.

The login config file can be placed anywhere, and be named as preferred. The path to the login file is given as a parameter on the command line.

Make sure to supply the path to the login file when invoking the code examples and tools that require this file as a command-line parameter.

Use the __passhash.php__ command-line tool to generate a password hash for use with the mylogin.json file.