<?php
/*
File: auth.php

This example shows how to send an /auth request to the server.

The returned JSON data is printed in raw unparsed format.

This is a very basic example that illustrates the use of PHP cURL
calls to perform a request. Intended for educational purposes only.

The other code examples use a REST API library that simplifies
making REST API calls considerably.

The /auth request obtains autentication data about the current
user. The response contains permission data and other items.

Note that the /auth request is not related to login. Every
request in the REST API carries an autentication token, and
in that sense "login" is performed on each and every request.

Importantly, the code below has to be edited to include the
user name and password hash. Use the passhash.php tool to
generate the password hash. The server name also may have to
be edited.

NOTE: Replace the placeholders in the code below with your
actual username and passhash!

Usage:

    php auth.php

Example:

    php auth.php
*/
require_once __DIR__ . "/../../tools/lib/authorization_lib.php";

// TODO: Replace with actual username and passhash
// Use tools/passhash/passhash.php to create the password hash
$username = "USERNAME";
$passhash = "PASSHASH";

// TODO: Replace the server URL if needed
$server_url = "https://demo.riotsecure.io:6443";

// Specficy the request method
$request_method = "GET";

// Specify the route URI:
$request_uri = "/auth";

// You can test other REST API routes by commenting out
// the above line and use one of the following URIs:
//$request_uri = "/modem";          // try setting $expand to true
//$request_uri = "/microntroller";  // try setting $expand to true
//$request_uri = "/global";         // does not have the expand option

// Should the result be expanded? (not all routes support expand)
$expand = false; // or true;

// Create the auth header (the request URI must not contain the expand option)
$auth_header = rest_api_authorization_header(
  $username, $passhash, $request_method, $request_uri);

// Specify HTTP request headers
$header = [
  $auth_header
];

// TODO: If needed, replace the address of the REST API server below
// The request URI may contain the expand option
$expand_option = $expand ? "?expand" : "";
$url = $server_url . $request_uri . $expand_option;
$curl = curl_init($url);

curl_setopt($curl, CURLOPT_HTTPHEADER, $header);
curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
curl_setopt($curl, CURLOPT_CUSTOMREQUEST, $request_method);
// Include the response header so it can be inspected
curl_setopt($curl, CURLOPT_HEADER, true);

$response = curl_exec($curl);

echo $response . PHP_EOL;

// It is considered best practice to not close the <?php tag
// in a PHP-only file.