<?php
/*
File: device_create.php

This script is an example of how to automate device creation.

The script takes the device name as input and creates a device
with that name.

Usage:

    php device_create.php LOGINFILE DEVICENAME

Example:

    php device_create.php mylogin.json "TEST DEVICE"

Note that all device properties execpt for the device name are
hard-coded into the script. An alternative solution is to provide
a JSON config file with the device data.

You can use this example as an inspiration for production scripts.
*/

require_once __DIR__ . "/../../tools/lib/rest_api_lib.php";
require_once __DIR__ . "/../../tools/lib/device_lib.php";

// Read config file with user credentials
if ($argc == 3)
{
  $login_config_file = $argv[1];
  $device_name       = $argv[2];

  // Read login file
  $config_path = get_absolute_path($login_config_file);
  rest_api_read_login_config($config_path);
}
else
{
  echo "USAGE:" . PHP_EOL;
  echo "php device_create.php LOGINFILE DEVICENAME" . PHP_EOL;
  echo "EXAMPLE:" . PHP_EOL;
  echo "php device_create.php mylogin.json \"Test Device\"" . PHP_EOL;
  die();
}

// Get tenant id
$tenant_id = rest_api_tenant_get_id();

// TODO: Change the device settings below as needed,
// or add command-line paramemters to the script.

// Device settings

// Network settings
$network_settings           = new stdClass();
$network_settings->SSID     = "MY WIFI NAME";
$network_settings->username = ""; // Must be set even if empty
$network_settings->password = "MY PASSWORD";

// Static GPS position (may be set to null)
$gps_settings               = new stdClass();
$gps_settings->latitude     = "59.916675";
$gps_settings->longitude    = "18.950068";

// Alternatively, static GPS position may be set to null
//$gps_settings = null;

$response = device_create(
  $tenant_id,
  $device_name,                       // device_name,
  "MKR WiFi 1010",                    // modem_name,
  "RIoT Fusion Shield - Arduino UNO", // hardware_interface_name,
  "1_0_0_16-riot-MKRWIFI1010",        // firmware_core_name,
  "WiFi",                             // network_type,
  $network_settings,                  // network_settings
  $gps_settings                       // gps_settings
);

if (201 !== rest_api_get_http_response_code())
{
  echo "ERROR: COULD NOT CREATE DEVICE" . PHP_EOL;
  echo $response . PHP_EOL;
}
else
{
  echo "SUCCESS: DEVICE CREATED WITH ID: {$response}" . PHP_EOL;
}
