<?php
/*
File: device_delete.php

This script shows an example of how to delete a device.

Usage:

    php device_delete.php LOGINFILE DEVICENAME

Example:

    php device_delete.php mylogin.json "Test Device"

The script could easily be modified to take a device id as
parameter instead of the device name.
*/

require_once __DIR__ . "/../../tools/lib/rest_api_lib.php";
require_once __DIR__ . "/../../tools/lib/device_lib.php";

// Set command params and read login config file
if ($argc == 3)
{
  $login_config_file = $argv[1]; // absolute or relative path to config file
  $device_name       = $argv[2]; // name of device to delete

  // Read login file
  $config_path = get_absolute_path($login_config_file);
  rest_api_read_login_config($config_path);
}
else
{
  echo "USAGE:" . PHP_EOL;
  echo "php device_delete.php LOGINFILE DEVICENAME" . PHP_EOL;
  echo "EXAMPLE:" . PHP_EOL;
  echo "php device_delete.php mylogin.json \"Test Device\"" . PHP_EOL;
  die();
}

// Get tenant id
$tenant_id = rest_api_tenant_get_id();

// Get the device with trhe given name
$device = device_find($tenant_id, $device_name);
if (false === $device)
{
  echo "ERROR: COULD NOT FIND DEVICE WITH NAME: " . $device_name . PHP_EOL;
  die();
}

// Delete the device
$response = device_delete($tenant_id, $device->id);

// Check response
if (204 === rest_api_get_http_response_code())
{
  echo "DEVICE DELETED: {$device_name}" . PHP_EOL;
}
else
{
  echo "ERROR: COULD NOT DELETE DEVICE" . PHP_EOL;
  echo $response . PHP_EOL;
}
