<?php
/*
File: device_get.php

This example uses a GET request to obtain info about the
first available device.

The returned JSON data is parsed and printed.

Usage:

    php device_get.php LOGINFILE

Example:

    php device_get.php mylogin.json
*/

require_once __DIR__ . "/../../tools/lib/rest_api_lib.php";

// Read config file with user credentials
if ($argc == 2)
{
  $login_config_file = $argv[1];
  $config_path = get_absolute_path($login_config_file);
  rest_api_read_login_config($config_path);
}
else
{
  echo "USAGE:" . PHP_EOL;
  echo "php device_get.php LOGINFILE" . PHP_EOL;
  echo "EXAMPLE:" . PHP_EOL;
  echo "php device_get.php mylogin.json" . PHP_EOL;
  die();
}

// Get id:s of all devices (returns JSON array of ids)
$tenant_id = rest_api_tenant_get_id();
$response = rest_api_get("/tenant/{$tenant_id}/device");

// Convert JSON to PHP array
$device_array = json_decode($response);

// Print device info for each device
foreach ($device_array as $device_id)
{
  // Get device data (returns JSON object)
  $response = rest_api_get_expand("/tenant/{$tenant_id}/device/{$device_id}");

  // Convert JSON to PHP object
  $device_obj = json_decode($response);

  // Print selected device data
  $date = (null != $device_obj->info->ts_comms)
    ? (DateTime::createFromFormat('U', $device_obj->info->ts_comms))->format("Y-m-d H:i:s")
    : "Unknown";

  echo "-----------------------------------" . PHP_EOL;
  echo "DEVICE ID       : {$device_obj->id}" . PHP_EOL;
  echo "DEVICE NAME     : {$device_obj->keys->name}" . PHP_EOL;
  echo "LAST SEEN       : {$date}" . PHP_EOL;

  // Print data about first microcontroller
  if (null != $device_obj->keys->microcontroller)
  {
    $microcontroller = $device_obj->keys->microcontroller[0];
    echo "MICROCONTROLLER =>" . PHP_EOL;
    echo "  NAME          : {$microcontroller->name}" . PHP_EOL;
    echo "  IDENTIFIER    : {$microcontroller->identifier}" . PHP_EOL;
    echo "  FIRMWARE_APPL : {$microcontroller->firmware_appl}" . PHP_EOL;
  }
}

// It is considered best practice to not close the <?php tag
// in a PHP-only file.