<?php
/*
File: firmware_appl_create.php

This example uses the library file device_lib.php to create a new
application firmware asset.

Usage:

    php firmware_appl_create.php LOGINFILE FIRMWARENAME MICROCONTROLLER VERSION DESCRIPTION FIRMWAREPATH

Example:

    php firmware_appl_create.php mylogin.json BlinkTest ATmega328P "100.0.0.1" "LED Blink Test" Blink.ino.hex
*/

require_once __DIR__ . "/../../tools/lib/rest_api_lib.php";
require_once __DIR__ . "/../../tools/lib/device_lib.php";

// Set command params and read login config file
if ($argc == 7)
{
  $login_config_file        = $argv[1]; // absolute or relative path to config file
  $firmware_name            = $argv[2]; // firmware name
  $firmware_microcontroller = $argv[3]; // microcontroller name
  $firmware_version         = $argv[4]; // firmware version
  $firmware_description     = $argv[5]; // firmware description
  $firmware_file            = $argv[6]; // absolute or relative path of firmware file

  // Read login file
  $config_path = get_absolute_path($login_config_file);
  rest_api_read_login_config($config_path);
}
else
{
  echo "USAGE:" . PHP_EOL;
  echo "php firmware_appl_create.php LOGINFILE FIRMWARENAME MICROCONTROLLER VERSION DESCRIPTION FIRMWAREPATH" . PHP_EOL;
  echo "EXAMPLE:" . PHP_EOL;
  echo "php firmware_appl_create.php mylogin.json \"BlinkTest\" \"ATmega328P\" \"100.0.0.1\" \"LED Blink Test\" Blink.ino.hex" . PHP_EOL;
  die();
}

// Get tenant id
$tenant_id = rest_api_tenant_get_id();

// Get absolute path to application firmware file
$firmware_absolute_path = get_absolute_path($firmware_file);

$response = firmware_appl_create(
  $tenant_id,
  $firmware_name,
  $firmware_microcontroller,
  $firmware_version,
  $firmware_description,
  $firmware_absolute_path);

// Check response
if (201 === rest_api_get_http_response_code())
{
  $firmware_name = $response;
  echo "FIRMWARE CREATED: {$firmware_name}" . PHP_EOL;
}
else
{
  echo "ERROR: COULD NOT CREATE FIRMWARE" . PHP_EOL;
  if ($response)
  {
    echo $response . PHP_EOL;
  }
  if (rest_api_get_curl_errno() > 0)
  {
    echo "CURL ERROR: " . rest_api_get_curl_error() . " " . rest_api_get_curl_errno() . PHP_EOL;
  }
}
