<?php
/*
File: firmware_appl_delete.php

This example shows how to delete an application firmware entry
using the library file device_lib.php.

Usage:

    php firmware_appl_delete.php LOGINFILE FIRMWARENAME

Example:

  php firmware_appl_delete.php mylogin.json BlinkTest
*/

require_once __DIR__ . "/../../tools/lib/rest_api_lib.php";
require_once __DIR__ . "/../../tools/lib/device_lib.php";

// Set command params and read login config file
if ($argc == 3)
{
  $login_config_file = $argv[1]; // absolute or relative path to config file
  $firmware_name     = $argv[2]; // firmware name is the id of the firmware

  // Read login file
  $config_path = get_absolute_path($login_config_file);
  rest_api_read_login_config($config_path);
}
else
{
  echo "USAGE:" . PHP_EOL;
  echo "php firmware_appl_delete.php LOGINFILE FIRMWARENAME" . PHP_EOL;
  echo "EXAMPLE:" . PHP_EOL;
  echo "php firmware_appl_delete.php mylogin.json \"BlinkTest\"" . PHP_EOL;
  die();
}

// Get tenant id
$tenant_id = rest_api_tenant_get_id();

// Make request to delete the firmware object
$response = firmware_appl_delete($tenant_id, $firmware_name);

// Check response
if (204 === rest_api_get_http_response_code())
{
  echo "FIRMWARE DELETED: {$firmware_name}" . PHP_EOL;
}
else
{
  echo "ERROR: COULD NOT DELETE FIRMWARE" . PHP_EOL;
  echo $response . PHP_EOL;
}
