<?php
/*
File: firmware_appl_get.php

This example shows how to get a list of available application firmwares.

The returned JSON data is parsed and the firmware name and version is printed.

Usage:

    php firmware_appl_get.php LOGINFILE

Example:

    php firmware_appl_get.php mylogin.json
*/

require_once __DIR__ . "/../../tools/lib/rest_api_lib.php";

// Read config file with user credentials
if ($argc == 2)
{
  $login_config_file = $argv[1];

  // Read login file
  $config_path = get_absolute_path($login_config_file);
  rest_api_read_login_config($config_path);
}
else
{
  echo "USAGE" . PHP_EOL;
  echo "php firmware_appl_get.php LOGINFILE" . PHP_EOL;
  echo "EXAMPLE:" . PHP_EOL;
  echo "php firmware_appl_get.php mylogin.json" . PHP_EOL;
  die();
}

// Get a list of firmware objects
$tenant_id = rest_api_tenant_get_id();
$response_json = rest_api_get_expand("/tenant/{$tenant_id}/firmware_appl");
$firmware_array = json_decode($response_json);

// Print firmwares
echo "AVAILABLE APPLICATION FIRMWARES:\n";
foreach ($firmware_array as $firmware)
{
  echo "{$firmware->name} {$firmware->info->version} {$firmware->info->microcontroller}" . PHP_EOL;
}
