<?php
/*
File: firmware_core_get.php

This example shows how to request a list available core firmwares.

Returned JSON data is printed in raw unparsed format.

Usage:

    php firmware_core_get.php LOGINFILE

Example:

    php firmware_core_get.php mylogin.json
*/

require_once __DIR__ . "/../../tools/lib/rest_api_lib.php";

// Read config file with user credentials
if ($argc == 2)
{
  $login_config_file = $argv[1];

  // Read login file
  $config_path = get_absolute_path($login_config_file);
  rest_api_read_login_config($config_path);
}
else
{
  echo "USAGE:" . PHP_EOL;
  echo "php firmware_core_get.php LOGINFILE" . PHP_EOL;
  echo "EXAMPLE:" . PHP_EOL;
  echo "php firmware_core_get.php mylogin.json" . PHP_EOL;
  die();
}

// Get a list of core firmwares
$response = rest_api_get("/firmware_core");

// Also try:
//$response = rest_api_get_expand("/firmware_core");

echo $response . PHP_EOL;
