<?php
/*
File: auth_permissions.php

This example uses a GET request to obtain info about permissions
for the current user.

Returned JSON data is parsed and printed.

Usage:

    php auth_permissions.php LOGINFILE

Example:

    php auth_permissions.php mylogin.json
*/

require_once __DIR__ . "/../../tools/lib/rest_api_lib.php";

// Read config file with user credentials
if ($argc == 2)
{
  $login_config_file = $argv[1];
  $config_path = get_absolute_path($login_config_file);
  rest_api_read_login_config($config_path);
}
else
{
  echo "USAGE:" . PHP_EOL;
  echo "php auth_permissions.php LOGINFILE" . PHP_EOL;
  echo "EXAMPLE:" . PHP_EOL;
  echo "php auth_permissions.php mylogin.json" . PHP_EOL;
  die();
}

// Get user info
$response_json = rest_api_get("/auth");
$user_info = json_decode($response_json);
$permissions = $user_info->permissions;

// List permissions
echo "AVAILABLE PERMISSIONS:\n";
echo "(C = Create, R = Read, U = Update, D = Delete, O = Options)\n";
foreach ($permissions as $route => $array)
{
  echo $route . " : ";
  foreach ($array as $permission)
  {
    echo $permission . " ";
  }
  echo "\n";
}

// It is considered best practice to not close the <?php tag
// in a PHP-only file.