<?php
/*
File: image_get.php

This example uses a GET request to download sample image assets
as files.

Files will be saved in a folder named __download__ in the current
working directory (the directory on which the command is invoked).

Usage:

    php image_get.php LOGINFILE

Example:

    php image_get.php mylogin.json
*/

require_once __DIR__ . "/../../tools/lib/rest_api_lib.php";

function download_image($image_id, $dir_path)
{
  $response = rest_api_get("/image/{$image_id}/download");
  if (!is_dir($dir_path))
  {
    mkdir($dir_path);
  }
  $image_path = $dir_path . "{$image_id}.png";
  $file = fopen($image_path, "wb");
  if ($file)
  {
    fwrite($file, $response);
    fclose($file);
  }
}

// Read config file with user credentials
if ($argc == 2)
{
  $login_config_file = $argv[1];
  $config_path = get_absolute_path($login_config_file);
  rest_api_read_login_config($config_path);
}
else
{
  echo "USAGE:" . PHP_EOL;
  echo "php image_get.php LOGINFILE" . PHP_EOL;
  echo "EXAMPLE:" . PHP_EOL;
  echo "php image_get.php mylogin.json" . PHP_EOL;
  die();
}

// Download sample images
$dir_path = getcwd() . "/download/";
download_image("modem-mkr1000", $dir_path);
download_image("modem-mkr-gsm-1400", $dir_path);
download_image("modem-mkr-nb-1500", $dir_path);
download_image("microcontroller-atmega328p", $dir_path);
download_image("microcontroller-atmega2560", $dir_path);
download_image("microcontroller-nRF52840", $dir_path);

echo "IMAGE FILES DOWNLOADED" . PHP_EOL;

// It is considered best practice to not close the <?php tag
// in a PHP-only file.