<?php
/*
File: microcontroller_get.php

This example uses a GET request to obtain info about microcontrollers
for the AVR architecture.

The returned JSON data is parsed and printed.

Usage:

    php microcontroller_get.php LOGINFILE

Example:

    php microcontroller_get.php mylogin.json
*/

require_once __DIR__ . "/../../tools/lib/rest_api_lib.php";

// Read config file with user credentials
if ($argc == 2)
{
  $login_config_file = $argv[1];
  $config_path = get_absolute_path($login_config_file);
  rest_api_read_login_config($config_path);
}
else
{
  echo "USAGE:" . PHP_EOL;
  echo "php microcontroller_get.php LOGINFILE" . PHP_EOL;
  echo "EXAMPLE:" . PHP_EOL;
  echo "php microcontroller_get.php mylogin.json" . PHP_EOL;
  die();
}

// Get id:s of all microcontrollers (returns JSON array of objects)
// These are the microcontrollers supported by the system
$response = rest_api_get_expand("/microcontroller");

// Convert JSON to PHP array
$microcontroller_array = json_decode($response);

// Print name and identifier of AVR microcontrollers
echo "AVAILABLE MICROCONTROLLERS FOR THE AVR ARCHITECTURE:" . PHP_EOL;
foreach ($microcontroller_array as $microcontroller)
{
  if ("avr" === $microcontroller->keys->arch)
  {
    if ($microcontroller->id < 10) { echo " "; } // print padding before single digit id
    echo $microcontroller->id . " " . $microcontroller->keys->identifier . " " . $microcontroller->keys->name . PHP_EOL;
  }
}

// It is considered best practice to not close the <?php tag
// in a PHP-only file.