<?php
/*
File: modem_get.php

This example uses a GET request to get data about modems.

The returned JSON data is printed in raw unparsed format.

Usage:

    php modem_get.php LOGINFILE

Example:

    php modem_get.php mylogin.json
*/

require_once __DIR__ . "/../../tools/lib/rest_api_lib.php";

// Read config file with user credentials
if ($argc == 2)
{
  $login_config_file = $argv[1];
  $config_path = get_absolute_path($login_config_file);
  rest_api_read_login_config($config_path);
}
else
{
  echo "USAGE:" . PHP_EOL;
  echo "php modem_get.php LOGINFILE" . PHP_EOL;
  echo "EXAMPLE:" . PHP_EOL;
  echo "php modem_get.php mylogin.json" . PHP_EOL;
  die();
}

// Get ids of all modems (without expand option)
$response = rest_api_get("/modem");

// Uncomment the following line to make the same request with the expand option
// (comment out the above line)
//$response = rest_api_get_expand("/modem");

// Uncomment the following line to get the single modem with id 3
// (comment out the above lines)
//$response = rest_api_get_expand("/modem/3");

// Display unparsed JSON data
echo $response . PHP_EOL;

// It is considered best practice to not close the <?php tag
// in a PHP-only file.