<?php
/*
File: tenant_get.php

This example uses a GET request to obtain info about the tenant.

The returned JSON data is printed in raw unparsed format.

Usage:

    php tenant_get.php LOGINFILE

Example:

    php tenant_get.php mylogin.json
*/

require_once __DIR__ . "/../../tools/lib/rest_api_lib.php";

// Read config file with user credentials
if ($argc == 2)
{
  $login_config_file = $argv[1];
  $config_path = get_absolute_path($login_config_file);
  rest_api_read_login_config($config_path);
}
else
{
  echo "USAGE:" . PHP_EOL;
  echo "php tenant_get.php LOGINFILE" . PHP_EOL;
  echo "EXAMPLE:" . PHP_EOL;
  echo "php tenant_get.php mylogin.json" . PHP_EOL;
  die();
}

// Get tenant JSON data
$tenant_id = rest_api_tenant_get_id();
$response = rest_api_get_expand("/tenant/{$tenant_id}");

// Print tenant data (unparsed string data)
echo $response . PHP_EOL;

// It is considered best practice to not close the <?php tag
// in a PHP-only file.