<?php
/*
File: call_rest_api.php

This example shows how to make an unauthorized REST API call.

Usage:

    php call_rest_api.php
*/

// Function that makes an HTTP GET request
function make_request($url)
{
  // Create a cURL object from a URL
  $curl = curl_init($url);
  // Set option to return the response from the request as a string
  curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
  // Specify GET as the request method
  curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "GET");
  // Include the response header so that it can be inspected
  curl_setopt($curl, CURLOPT_HEADER, true);
  // Execute the request
  $response = curl_exec($curl);
  // Return the response string
  return $response;
}

// Attempt to call the REST API without authorization
// HTTP error code 401 will be returned ("Unauthorized")
$response = make_request("https://demo.riotsecure.io:6443/auth");
echo $response;

// It is considered best practice to not close the <?php tag
// in a PHP-only file.