<?php
/*
Library for terminal control using ANSI codes.
*/

// https://wiki.plecko.hr/doku.php?id=development:php:cli_cursor
// https://en.wikipedia.org/wiki/ANSI_escape_code#CSIsection
// https://en.wikipedia.org/wiki/Box-drawing_character
// https://stackoverflow.com/questions/55892416/how-to-get-cursor-position-with-php-cli

define("ESC", "\033");
define("CSI", ESC."[");
define("HEART", "\u{1F497}");
define("VBAR", "\u{2503}");

function CursorForward($n) { echo CSI.$n."C"; }
function CursorBack($n) { echo CSI.$n."D"; }
function CursorSave() { echo CSI."s"; }
function CursorRestore() { echo CSI."u"; }
function CursorColumn($n) { echo CSI.$n."G"; }
//function CursorShow() { echo CSI."?25h"; }
//function CursorHide() { echo CSI."?25l"; }

function TextWhite() { echo CSI."37m"; }
function TextGray() { echo CSI."90m"; }
function BackgroundWhite() { echo CSI."107m"; }
function BackgroundGray() { echo CSI."47m"; }

function AnsiReset() { echo CSI."0m"; }

// It is considered best practice to not close the <?php tag
// in a PHP-only file.