<?php
// REST API library functions for computing authentication tokens

function md5_uppercase($string)
{
  return strtoupper(md5($string));
}

function rest_api_nonce()
{
  $part1 = dechex(time());
  $part2 = bin2hex(random_bytes(12));
  return strtoupper($part1 . $part2);
}

function rest_api_passhash($username, $password)
{
  $realm    = "riotsecure";
  $passhash = md5_uppercase($username . ":" . $realm . ":" . $password);
  return $passhash;
}

function rest_api_authority($passhash, $request_method, $request_uri, $nonce)
{
  $request_hash = md5_uppercase($request_method . ":" . $request_uri);
  $authority    = md5_uppercase($passhash  . ":" . $nonce . ":" . $request_hash);
  return $authority;
}

function rest_api_authorization_header($username, $passhash, $request_method, $request_uri)
{
  $nonce       = rest_api_nonce();
  $authority   = rest_api_authority($passhash, $request_method, $request_uri, $nonce);

  $auth_header = "Authorization: oasis " .
                 "username=\"{$username}\", " .
                 "nonce=\"{$nonce}\", " .
                 "authority=\"{$authority}\"";

  return $auth_header;
}

// It is considered best practice to not close the <?php tag
// in a PHP-only file.