<?php
/*
File: passhash.php

Generate the password hash token used in the REST API login config file.

Outputs the login token. Copy and paste this token into the login.json file.

Usage:

    php passhash.php USERNAME PASSWORD

Example command and output:

    php passhash.php "user@email.com" "mysecretpassword"
    D7E483322282838AD065CE815D5EE05F
*/

require_once __DIR__ . "/../lib/authorization_lib.php";

if ($argc != 3)
{
  echo "Create a password hash token" . PHP_EOL;
  echo "Usage:" . PHP_EOL;
  echo "php passhash.php \"username\" \"password\"" . PHP_EOL;
}
else
{
  $username = $argv[1];
  $password = $argv[2];
  echo rest_api_passhash($username, $password) . PHP_EOL;
}
